/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverestore;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class UpgradePropertiesData
implements UpgradeData {
    private static final String TRACE_MASKT = "XSAVPROT";
    private static final String TRACE_MASKF = "XSAVPROF";
    private static final String TRACE_MASKD = "XSAVPROD";
    protected String versionNumber;

    public UpgradePropertiesData() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradePropertiesData() Constructor");
        this.versionNumber = "00001";
        Trace.trace(TRACE_MASKT, "<- UpgradePropertiesData() Constructor");
    }

    public String getUpgradeDataVersion() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradePropertiesData.getUpgradeDataVersion()");
        Trace.trace(TRACE_MASKF, "Version number is : " + this.versionNumber);
        Trace.trace(TRACE_MASKT, "<- UpgradePropertiesData.getUpgradeDataVersion()");
        return this.versionNumber;
    }

    public void saveUpgradeData(OutputStream fileNameZip) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradePropertiesData.saveUpgradeData(OutputStream StreamNameOut)");
        byte[] buf = new byte[1024];
        ZipOutputStream zos = null;
        try {
            Trace.trace(TRACE_MASKF, "Flush stream");
            fileNameZip.flush();
            try {
                int len;
                FileInputStream is;
                ZipEntry ze;
                Trace.trace(TRACE_MASKF, "Open zip file stream");
                zos = new ZipOutputStream(fileNameZip);
                Trace.trace(TRACE_MASKF, "Zip file stream openned");
                zos.setMethod(8);
                Trace.trace(TRACE_MASKF, "Zip file parameter 1 done");
                zos.setComment("compressed");
                Trace.trace(TRACE_MASKF, "Zip file parameter 2 done");
                String filepath = BaseFileControl.getFilePath("defaultuserpref.properties");
                Trace.trace(TRACE_MASKF, "defaultuserpref.properties file path is : " + filepath);
                String str = filepath + "defaultuserpref.properties";
                Trace.trace(TRACE_MASKF, "Properties file location is : " + str);
                File fileobject = new File(str);
                if (fileobject.exists()) {
                    ze = new ZipEntry("defaultuserpref.properties");
                    is = new FileInputStream(str);
                    Trace.trace(TRACE_MASKF, str + " File length is : " + fileobject.length());
                    Trace.trace(TRACE_MASKF, "Zip entry created");
                    zos.putNextEntry(ze);
                    Trace.trace(TRACE_MASKF, "Entry written to zip File");
                    while ((len = is.read(buf)) >= 0) {
                        zos.write(buf, 0, len);
                    }
                    Trace.trace(TRACE_MASKF, "File " + str + " written to Zip file");
                    is.close();
                } else {
                    Trace.trace(TRACE_MASKF, "File " + str + " not found, continuing on to next file.");
                }
                filepath = BaseFileControl.getFilePath("defaultuserpref.z.properties");
                Trace.trace(TRACE_MASKF, "defaultuserpref.z.properties data file path is : " + filepath);
                str = filepath + "defaultuserpref.z.properties";
                Trace.trace(TRACE_MASKF, "Properties data file location is : " + str);
                fileobject = new File(str);
                if (fileobject.exists()) {
                    ze = new ZipEntry("defaultuserpref.z.properties");
                    is = new FileInputStream(str);
                    Trace.trace(TRACE_MASKF, str + " File length is : " + fileobject.length());
                    Trace.trace(TRACE_MASKF, "Zip entry created");
                    zos.putNextEntry(ze);
                    Trace.trace(TRACE_MASKF, "Entry written to zip File");
                    while ((len = is.read(buf)) >= 0) {
                        zos.write(buf, 0, len);
                    }
                    Trace.trace(TRACE_MASKF, "File " + str + " written to Zip file");
                    is.close();
                } else {
                    Trace.trace(TRACE_MASKF, "File " + str + " not found, continuing on to next file.");
                }
                filepath = BaseFileControl.getFilePath("defaultuserpref.fiber.properties");
                Trace.trace(TRACE_MASKF, "defaultuserpref.fiber.properties data file path is : " + filepath);
                str = filepath + "defaultuserpref.fiber.properties";
                Trace.trace(TRACE_MASKF, "Properties data file location is : " + str);
                fileobject = new File(str);
                if (fileobject.exists()) {
                    ze = new ZipEntry("defaultuserpref.fiber.properties");
                    is = new FileInputStream(str);
                    Trace.trace(TRACE_MASKF, str + " File length is : " + fileobject.length());
                    Trace.trace(TRACE_MASKF, "Zip entry created");
                    zos.putNextEntry(ze);
                    Trace.trace(TRACE_MASKF, "Entry written to zip File");
                    while ((len = is.read(buf)) >= 0) {
                        zos.write(buf, 0, len);
                    }
                    Trace.trace(TRACE_MASKF, "File " + str + " written to Zip file");
                    is.close();
                } else {
                    Trace.trace(TRACE_MASKF, "File " + str + " not found, finishing up program.");
                }
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException occurred zipping Properties data: " + e);
                UpgradeDataException hexe = new UpgradeDataException(e);
                hexe.setCriticalDataError();
                throw hexe;
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKF, "HException while zipping Properties data");
                UpgradeDataException hexe = new UpgradeDataException(e);
                hexe.setCriticalDataError();
                throw hexe;
            }
            finally {
                Trace.trace(TRACE_MASKF, "Doing final cleanup for try 02 block");
                zos.finish();
                zos.close();
            }
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Unexpected IOException occurred in UpgradePropertiesData: " + e);
            UpgradeDataException hexe = new UpgradeDataException(e);
            hexe.setCriticalDataError();
            throw hexe;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradePropertiesData.saveUpgradeData(OutputStream StreamNameOut)");
    }

    public void restoreUpgradeData(InputStream streamNameIn, String versionLevel) throws UpgradeDataException {
        boolean status = false;
        byte[] readBuffer = new byte[4096];
        Trace.trace(TRACE_MASKT, "-> UpgradePropertiesData.restoreUpgradeData(streamName, version)");
        Trace.trace(TRACE_MASKT, "UpgradePropertiesData.restoreUpgradeData version is :" + versionLevel);
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(streamNameIn);
            while ((ze = zis.getNextEntry()) != null) {
                int bytesRead;
                String zipEntryName = ze.getName();
                Trace.trace(TRACE_MASKF, "Zip entry name is :" + zipEntryName);
                String upgradePath = BaseFileControl.getFilePath(zipEntryName);
                Trace.trace(TRACE_MASKF, "Properties Path is : " + upgradePath);
                String fullname = upgradePath + zipEntryName;
                Trace.trace(TRACE_MASKF, "fullname is " + fullname);
                File fileunzip = new File(fullname);
                if (fileunzip.exists()) {
                    Trace.trace(TRACE_MASKF, "file " + fullname + " exists");
                    fileunzip.delete();
                    Trace.trace(TRACE_MASKF, "file " + fullname + " deleted");
                }
                fileunzip.createNewFile();
                FileOutputStream fileOutput = new FileOutputStream(fileunzip);
                while ((bytesRead = zis.read(readBuffer)) > 0) {
                    fileOutput.write(readBuffer, 0, bytesRead);
                }
                fileOutput.close();
                Trace.trace(TRACE_MASKF, "File size written is :" + ze.getSize());
                zis.closeEntry();
            }
            Trace.trace(TRACE_MASKF, "Close zip input stream");
            zis.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Unexpected IOException occurred Restore Properties Data: " + e);
            UpgradeDataException hexe = new UpgradeDataException(e);
            hexe.setCriticalDataError();
            throw hexe;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "HException occurred on Restore Properties Data: " + e);
            UpgradeDataException hexe = new UpgradeDataException(e);
            hexe.setCriticalDataError();
            throw hexe;
        }
        finally {
            Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradePropertiesData.restoreUpgradeData");
        }
        Trace.trace(TRACE_MASKT, "<- UpgradePropertiesData.restoreUpgradeData(streamName, version)");
    }
}

